#include <library/cpp/testing/gtest/gtest.h>

#include <solomon/services/memstore/api/memstore_service.pb.h>
#include <solomon/services/memstore/lib/api/proto.h>
#include <solomon/services/memstore/lib/index/shard.h>

using namespace NSolomon;
using namespace NMemStore;

using yandex::monitoring::memstore::FindResponse;

TEST(TFindHandlerTest, ToProtoEmpty) {
    NIndex::TShardEvents::TFindResponse shardResp;

    FindResponse protoResp;
    NApi::ToProto(shardResp, &protoResp);

    ASSERT_FALSE(protoResp.has_string_pool());
    ASSERT_EQ(protoResp.metrics_size(), 0);
    ASSERT_EQ(protoResp.total_count(), 0u);
    ASSERT_FALSE(protoResp.truncated());
}

TEST(TFindHandlerTest, ToProtoNonEmpty) {
    FindResponse protoResp;

    {
        NStringPool::TStringPoolBuilder strings;
        std::vector<TMetric> metrics{
            {NTsModel::EPointType::DGauge, strings.Put(""), { // TODO: support names
                {strings.Put("host"), strings.Put("memstore-sas-00")},
                {strings.Put("sensor"), strings.Put("cpu_usage")},
            }},
            {NTsModel::EPointType::Rate, strings.Put(""), { // TODO: support names
                {strings.Put("sensor"), strings.Put("mem_usage")},
                {strings.Put("host"), strings.Put("memstore-sas-00")},
            }},
        };

        NIndex::TShardEvents::TFindResponse shardResp{strings.Build(), std::move(metrics), 100};
        NApi::ToProto(shardResp, &protoResp);
    }

    ASSERT_TRUE(protoResp.has_string_pool());
    NStringPool::TStringPool strings{protoResp.string_pool()};
    ASSERT_EQ(strings.Size(), 5u);
    ASSERT_EQ(strings[0], "");
    ASSERT_EQ(strings[1], "host");
    ASSERT_EQ(strings[2], "memstore-sas-00");
    ASSERT_EQ(strings[3], "sensor");
    ASSERT_EQ(strings[4], "cpu_usage");
    ASSERT_EQ(strings[5], "mem_usage");

    ASSERT_EQ(protoResp.metrics_size(), 2);

    {
        const auto& m = protoResp.metrics(0);
        ASSERT_EQ(m.type(), yandex::solomon::model::MetricType::DGAUGE);

        ASSERT_EQ(m.labels_idx_size(), 4);
        ASSERT_EQ(strings[m.labels_idx(0)], "host");
        ASSERT_EQ(strings[m.labels_idx(1)], "memstore-sas-00");
        ASSERT_EQ(strings[m.labels_idx(2)], "sensor");
        ASSERT_EQ(strings[m.labels_idx(3)], "cpu_usage");
    }
    {
        const auto& m = protoResp.metrics(1);
        ASSERT_EQ(m.type(), yandex::solomon::model::MetricType::RATE);

        ASSERT_EQ(m.labels_idx_size(), 4);
        ASSERT_EQ(strings[m.labels_idx(0)], "sensor");
        ASSERT_EQ(strings[m.labels_idx(1)], "mem_usage");
        ASSERT_EQ(strings[m.labels_idx(2)], "host");
        ASSERT_EQ(strings[m.labels_idx(3)], "memstore-sas-00");
    }

    ASSERT_EQ(protoResp.total_count(), 100u);
    ASSERT_TRUE(protoResp.truncated());
}
