#include <library/cpp/testing/gtest/gtest.h>

#include <solomon/services/memstore/api/memstore_service.pb.h>
#include <solomon/services/memstore/lib/api/proto.h>
#include <solomon/services/memstore/lib/index/shard.h>

using namespace NSolomon;
using namespace NMemStore;

using yandex::monitoring::memstore::LabelKeysResponse;

TEST(TLabelKeysHandlerTest, ToProtoEmpty) {
    NIndex::TShardEvents::TLabelKeysResponse shardResp;

    LabelKeysResponse protoResp;
    NApi::ToProto(shardResp, &protoResp);

    ASSERT_FALSE(protoResp.has_string_pool());
    ASSERT_EQ(protoResp.keys_idx_size(), 0);
}

TEST(TLabelKeysHandlerTest, ToProtoNonEmpty) {
    LabelKeysResponse protoResp;

    {
        NStringPool::TStringPoolBuilder strings;
        std::vector<ui32> keys;
        keys.push_back(strings.Put("host"));
        keys.push_back(strings.Put("sensor"));
        keys.push_back(strings.Put("type"));
        keys.push_back(strings.Put("code"));

        NIndex::TShardEvents::TLabelKeysResponse shardResp{strings.Build(), std::move(keys)};
        NApi::ToProto(shardResp, &protoResp);
    }

    ASSERT_TRUE(protoResp.has_string_pool());
    NStringPool::TStringPool strings{protoResp.string_pool()};
    ASSERT_EQ(strings.Size(), 4u);
    ASSERT_EQ(strings[0], "");
    ASSERT_EQ(strings[1], "host");
    ASSERT_EQ(strings[2], "sensor");
    ASSERT_EQ(strings[3], "type");
    ASSERT_EQ(strings[4], "code");

    ASSERT_EQ(protoResp.keys_idx_size(), 4);

    auto& keysIdx = protoResp.keys_idx();
    ASSERT_EQ(strings[keysIdx[0]], "host");
    ASSERT_EQ(strings[keysIdx[1]], "sensor");
    ASSERT_EQ(strings[keysIdx[2]], "type");
    ASSERT_EQ(strings[keysIdx[3]], "code");
}
