#include <library/cpp/testing/gtest/gtest.h>

#include <solomon/services/memstore/api/memstore_service.pb.h>
#include <solomon/services/memstore/lib/api/proto.h>
#include <solomon/services/memstore/lib/index/shard.h>

using namespace NSolomon;
using namespace NMemStore;

using yandex::monitoring::memstore::LabelValuesResponse;

TEST(TLabelValuesHandlerTest, ToProtoEmpty) {
    NIndex::TShardEvents::TLabelValuesResponse shardResp;

    LabelValuesResponse protoResp;
    NApi::ToProto(shardResp, &protoResp);

    ASSERT_FALSE(protoResp.has_string_pool());
    ASSERT_EQ(protoResp.labels_size(), 0);
    ASSERT_EQ(protoResp.metric_count(), 0u);
}

TEST(TLabelValuesHandlerTest, ToProtoNonEmpty) {
    LabelValuesResponse protoResp;

    {
        using TLabelState = NIndex::TShardEvents::TLabelValuesResponse::TLabelState;

        NStringPool::TStringPoolBuilder strings;
        std::vector<TLabelState> labels;
        labels.emplace_back(TLabelState{
            {
                strings.Put("memstore-sas-00"),
                strings.Put("memstore-sas-01"),
            },
            strings.Put("host"),
            15u,
            true,
        });
        labels.emplace_back(TLabelState{
            {
                strings.Put("cpu_usage"),
                strings.Put("mem_usage"),
            },
            strings.Put("sensor"),
            3u,
            false,
        });

        NIndex::TShardEvents::TLabelValuesResponse shardResp{
            strings.Build(),
            std::move(labels),
            42u
        };
        NApi::ToProto(shardResp, &protoResp);
    }

    ASSERT_TRUE(protoResp.has_string_pool());
    NStringPool::TStringPool strings{protoResp.string_pool()};
    ASSERT_EQ(strings.Size(), 6u);
    ASSERT_EQ(strings[0], "");
    ASSERT_EQ(strings[1], "memstore-sas-00");
    ASSERT_EQ(strings[2], "memstore-sas-01");
    ASSERT_EQ(strings[3], "host");
    ASSERT_EQ(strings[4], "cpu_usage");
    ASSERT_EQ(strings[5], "mem_usage");
    ASSERT_EQ(strings[6], "sensor");

    ASSERT_EQ(protoResp.labels_size(), 2);

    {
        const auto& l = protoResp.labels(0);
        ASSERT_EQ(strings[l.key_idx()], "host");
        ASSERT_EQ(l.total_count(), 15u);
        ASSERT_TRUE(l.truncated());

        ASSERT_EQ(l.values_idx_size(), 2);
        std::set<ui32> values{l.values_idx(0), l.values_idx(1)};
        std::set<ui32> expected{1, 2}; // according to table above
        ASSERT_EQ(values, expected);
    }

    {
        const auto& l = protoResp.labels(1);
        ASSERT_EQ(strings[l.key_idx()], "sensor");
        ASSERT_EQ(l.total_count(), 3u);
        ASSERT_FALSE(l.truncated());

        ASSERT_EQ(l.values_idx_size(), 2);
        std::set<ui32> values{l.values_idx(0), l.values_idx(1)};
        std::set<ui32> expected{4, 5}; // according to table above
        ASSERT_EQ(values, expected);
    }
}
