#pragma once

#include <solomon/services/memstore/config/memstore_benchmark_config.pb.h>
#include <solomon/services/memstore/config/memstore_config.pb.h>
#include <solomon/services/memstore/lib/types.h>

#include <solomon/protos/configs/data_size.pb.h>
#include <solomon/protos/configs/time.pb.h>

#include <library/cpp/protobuf/util/pb_io.h>

#include <util/datetime/base.h>
#include <util/generic/yexception.h>
#include <util/stream/file.h>

#include <google/protobuf/descriptor.h>
#include <google/protobuf/text_format.h>

namespace NSolomon::NMemStore::NConfig {

/**
 * All MemStore configs.
 */
using TMemStoreConfig = yandex::monitoring::memstore::MemStoreConfig;
using TMemStoreBenchmarkConfig = yandex::monitoring::memstore::MemStoreBenchmarkConfig;
using TWriteQueueConfig = yandex::monitoring::memstore::WriteQueueConfig;

/**
 * Syntax error in config.
 */
class TConfigParseException: public yexception {};

/**
 * Semantic error in config.
 */
class TConfigValidationException: public yexception {};

/**
 * Load and validate MemStore config from file.
 *
 * Throws `TConfigParseException` if config file is malformed.
 * Throws `TConfigValidationException` if config has errors.
 */
TMemStoreConfig Load(const TString& filePath);

TMemStoreConfig ParseTextProto(const TString& filePath);
void Validate(const TMemStoreConfig& config);

TMemStoreBenchmarkConfig LoadBenchmarkConfig(const TString& filePath);

/**
 * Returns current node id as configured in static cluster mapping.
 * @param config   cluster mapping
 * @return valid node id
 * @throws TConfigValidationException if cluster mapping has no entry for current node
 */
TNodeId GetNodeId(const yandex::monitoring::config::StaticClusterMapping& config);

} // namespace NSolomon::NMemStore::NConfig
