#include <solomon/services/memstore/lib/config/config.h>

#include <library/cpp/resource/resource.h>
#include <library/cpp/testing/gtest/gtest.h>

#include <util/system/tempfile.h>

using namespace NSolomon::NMemStore::NConfig;

namespace {

void ValidateResource(TStringBuf name) {
    TString configText = NResource::Find(name);
    ASSERT_FALSE(configText.Empty()) << "cannot find resource " << name;

    TTempFileHandle tmp;
    tmp.Write(configText.data(), configText.size());
    tmp.FlushData();

    TMemStoreConfig config;
    ASSERT_NO_THROW({ config = ParseTextProto(tmp.Name()); }) << "cannot parse config " << name;
    ASSERT_NO_THROW({ Validate(config); }) << "non valid config " << name;
}

} // namespace

TEST(TConfigTest, Prestable) {
    ValidateResource("prestable/memstore.conf");
}

TEST(TConfigTest, Production) {
    ValidateResource("production/memstore.conf");
}

TEST(TConfigTest, Dev) {
    ValidateResource("dev/memstore.conf");
}
