#pragma once

#include <solomon/libs/cpp/search/search_index.h>

namespace NSolomon::NMemStore {

struct TMetricId {
    ui32 ShardNo;
    ui32 TsId;

    constexpr NSearch::ISearchResult::TId Pack() const noexcept {
        constexpr ui32 TsIdMask1 = 0x00FFFF00u;
        constexpr ui32 TsIdMask2 = 0x000000FFu;
        constexpr ui32 ShardIdMask = 0x000000FFu;

        Y_ASSERT((ShardNo & ShardIdMask) == ShardNo);
        Y_ASSERT((TsId & (TsIdMask1 | TsIdMask2)) == TsId);

        return ((TsId & TsIdMask1) << 8) | ((ShardNo & ShardIdMask) << 8) | (TsId & TsIdMask2);
    }

    static constexpr TMetricId Unpack(NSearch::ISearchResult::TId packedId) noexcept {
        constexpr ui32 TsIdMask1 = 0xFFFF0000u;
        constexpr ui32 TsIdMask2 = 0x000000FFu;
        constexpr ui32 ShardIdMask = 0x0000FF00u;

        const ui32 tsId = ((packedId & TsIdMask1) >> 8) | (packedId & TsIdMask2);
        const ui32 shardNo = (packedId & ShardIdMask) >> 8;

        return TMetricId{shardNo, tsId};
    }
};

} // namespace NSolomon::NMemStore
