#pragma once

#include "index_limiter.h"
#include "write_request.h"

#include <solomon/services/memstore/lib/types.h>
#include <solomon/services/memstore/lib/index/metrics.h>

#include <solomon/libs/cpp/actors/fwd.h>
#include <solomon/libs/cpp/metering/shard_metrics_repo.h>

namespace NSolomon::NMemStore::NIndex {

/**
 * An actor that parses data and sends it to sub shards.
 *
 * @param shard         shard that initiated this operation.
 * @param subShards     subshards where data should be relayed after initial parsing.
 * @param frame         frame index into which the data will be inserted.
 * @param requests      data to process.
 */
std::unique_ptr<NActors::IActor> CreateAddPointActor(
        NActors::TActorId shard,
        TVector<NActors::TActorId> subShards,
        TFrameIdx frame,
        TVector<TAddPointRequest> requests,
        std::shared_ptr<TMetrics> metrics,
        NActors::TActorId indexLimiterId,
        NActors::TActorId subscriber = {},
        std::shared_ptr<IResourceUsageContext> shardMeteringContext = nullptr);

} // namespace NSolomon::NMemStore::NIndex
