#pragma once

#include <solomon/libs/cpp/actors/fwd.h>
#include <solomon/libs/cpp/metering/shard_metrics_repo.h>

#include <util/generic/vector.h>

#include <solomon/services/memstore/lib/index/metrics.h>

namespace NSolomon::NMemStore::NIndex {

/**
 * An actor that gathers responses from sub shards and processes 'label values' requests.
 */
std::unique_ptr<NActors::IActor> CreateLabelValuesActor(
        std::vector<NActors::TActorId> subShards,
        NActors::TActorId fts,
        std::shared_ptr<IResourceUsageContext> shardMeteringContext,
        std::shared_ptr<TMetrics> metrics);

} // namespace NSolomon::NMemStore::NIndex
