#include "memory_tools.h"

#include <contrib/libs/tcmalloc/tcmalloc/malloc_extension.h>

namespace NSolomon::NMemStore::NIndex {

std::optional<size_t> GetMemoryCommitted() {
    auto bytesCommitted = tcmalloc::MallocExtension::GetNumericProperty("generic.heap_size");
    return bytesCommitted;
}

void SetMemoryLimit(size_t limit) {
    tcmalloc::MallocExtension::MemoryLimit memoryLimit;
    memoryLimit.limit = limit;
    memoryLimit.hard = false;
    tcmalloc::MallocExtension::SetMemoryLimit(memoryLimit);
}

}
