#pragma once

#include <solomon/services/memstore/lib/index/metrics.h>
#include <solomon/services/memstore/lib/types.h>

#include <solomon/libs/cpp/actors/fwd.h>
#include <solomon/libs/cpp/metering/shard_metrics_repo.h>
#include <solomon/libs/cpp/selectors/selectors.h>
#include <solomon/libs/cpp/stockpile_codec/format.h>
#include <solomon/libs/cpp/string_pool/string_pool.h>
#include <solomon/libs/cpp/ts_math/operation_pipeline.h>
#include <solomon/services/memstore/lib/event_slots.h>

#include <library/cpp/actors/core/event_local.h>

namespace NSolomon::NMemStore::NIndex {

/**
 * An actor that parses data and sends it to subshards.
 *
 * @param numId         id of the shard that we are reading from.
 * @param subShards     list of subshards we take data from.
 * @param fts           Fts Index actor id, where we can find metrics by selector
 */
std::unique_ptr<NActors::IActor> CreateReadOneActor(
        TNumId numId,
        TVector<NActors::TActorId> subShards,
        NActors::TActorId fts,
        std::shared_ptr<IResourceUsageContext> shardMeteringContext,
        std::shared_ptr<TMetrics> metrics);

std::unique_ptr<NActors::IActor> CreateReadManyActor(
        TNumId numId,
        TVector<NActors::TActorId> subShards,
        NActors::TActorId fts,
        std::shared_ptr<IResourceUsageContext> shardMeteringContext,
        std::shared_ptr<TMetrics> metrics);

} // namespace NSolomon::NMemStore::NIndex
