#include "shard_manager_config.h"

namespace NSolomon::NMemStore::NIndex {

TShardManagerConfig::TShardManagerConfig(
        TDuration chunkLength,
        TDuration indexCapacity,
        ui8 numSubshards,
        std::shared_ptr<TShardMeteringMetricsRepository> meteringMetricsRepo,
        NActors::TActorId localShardProvider)
    : ChunkLength(chunkLength)
    , IndexCapacity(indexCapacity)
    , NumSubshards(numSubshards)
    , MeteringMetricsRepo(std::move(meteringMetricsRepo))
    , NumChunks(IndexCapacity.Seconds() / ChunkLength.Seconds())
    , LocalShardProvider(localShardProvider)
{
    Y_ASSERT(ChunkLength * NumChunks == IndexCapacity);
    Y_ASSERT(ChunkLength > TDuration::Seconds(1));
    Y_ASSERT(0 < NumChunks && NumChunks < 100);
    Y_ASSERT(NumSubshards > 0);
}

} // namespace NSolomon::NMemStore::NIndex
