#pragma once

#include <solomon/libs/cpp/metering/shard_metrics_repo.h>

#include <library/cpp/actors/core/actor.h>

#include <util/datetime/base.h>

namespace NSolomon::NMemStore::NIndex {

/**
 * Settings for index.
 */
struct TShardManagerConfig {

    TShardManagerConfig(
            TDuration chunkLength = TDuration::Minutes(5),
            TDuration indexCapacity = TDuration::Minutes(30),
            ui8 numSubshards = 64,
            std::shared_ptr<TShardMeteringMetricsRepository> meteringMetricsRepo = nullptr,
            NActors::TActorId localShardProvider = {});

    /**
     * How long of a time series can a single chunk contain?
     */
    const TDuration ChunkLength;

    /**
     * When chunks are destroyed?
     */
    const TDuration IndexCapacity;

    /**
     *  How many subshard has each shard
     */
    const ui8 NumSubshards;

    /**
     * Class for collecting per-shard metrics and calculating aggregates
     */
    std::shared_ptr<TShardMeteringMetricsRepository> MeteringMetricsRepo;

    /**
     * How many chunks we are store
     */
    const size_t NumChunks;

    /**
     * Actor providing configs for local shards MemStore should process
     */
    NActors::TActorId LocalShardProvider;

    /**
     * Executor pool ID which will be used for per request actors.
     */
    ui32 RequestPool{0};

    /**
     * Executor pool ID for FTS index.
     */
    ui32 FtsPool{0};
};

} // namespace NSolomon::NMemStore::NIndex
