#pragma once

#include <solomon/services/memstore/lib/types.h>

#include <solomon/libs/cpp/actors/fwd.h>
#include <solomon/libs/cpp/metering/shard_metrics_repo.h>

#include <solomon/services/memstore/lib/index/metrics.h>

namespace NSolomon::NMemStore::NIndex {

/**
 * An actor that collects and serializes a snapshot. This actor will wait until it receives `numSubShards` events
 * with snapshot data, then build a snapshot, send it to the shard actor, and pass away.
 *
 * Note that this actor does not send `TSealAndSnapshotFrame` messages.
 *
 * @param shard             id of the shard.
 * @param numId             shard's identifier.
 * @param frameIdx          index of the frame being snapshotted.
 * @param logId             latest log id in the snapshot.
 * @param numSubShards      expected number of `TSealAndSnapshotFrameDone` messages.
 * @param shardMeteringContext object for collecting per-shard metrics
 */
std::unique_ptr<NActors::IActor> CreateSnapshotActor(
        NActors::TActorId shard,
        TNumId numId,
        TFrameIdx frameIdx,
        TLogId logId,
        size_t numSubShards,
        std::shared_ptr<TMetrics> metrics,
        std::shared_ptr<IResourceUsageContext> shardMeteringContext = nullptr);

} // namespace NSolomon::NMemStore::NIndex
