#pragma once

#include <solomon/services/memstore/lib/index/metrics.h>
#include <solomon/services/memstore/lib/types.h>

#include <solomon/libs/cpp/actors/fwd.h>
#include <solomon/libs/cpp/metering/shard_metrics_repo.h>

namespace NSolomon::NMemStore::NIndex {

/**
 * An actor that gathers responses from sub shards and processes 'unique labels' requests.
 */
std::unique_ptr<NActors::IActor> CreateUniqueLabelsActor(
        std::vector<NActors::TActorId> subShards,
        NActors::TActorId fts,
        std::shared_ptr<IResourceUsageContext> shardMeteringContext,
        std::shared_ptr<TMetrics> metrics);

} // namespace NSolomon::NMemStore::NIndex
