#include "common.h"

using namespace NActors;

void TIndexTestBase::ExecuteInContext(std::function<void(const TActorContext&)> f) {
    class TActorFunc: public TActor<TActorFunc> {
    public:
        explicit TActorFunc(std::function<void(const TActorContext&)> f)
            : TActor<TActorFunc>{&TThis::Main}
            , F_{std::move(f)}
        {
        }

    public:
        STATEFN(Main) {
            Y_VERIFY(ev->GetTypeRewrite() == TEvents::TEvPing::EventType);
            F_(TActorContext::AsActorContext());
            Send(ev->Sender, new TEvents::TEvPong{});
            PassAway();
        }

    private:
        std::function<void(const TActorContext&)> F_;
    };

    auto sys = Runtime->GetAnyNodeActorSystem();
    auto actor = sys->Register(new TActorFunc{std::move(f)});
    auto future = sys->Ask<TEvents::TEvPong>(actor, MakeHolder<TEvents::TEvPing>());
    TDispatchOptions opts;
    opts.CustomFinalCondition = [&]() { return future.HasValue(); };
    Runtime->DispatchEvents(opts);
}
