#pragma once

#include <solomon/services/memstore/lib/index/metrics.h>
#include <solomon/services/memstore/lib/time_series/time_series.h>
#include <solomon/services/memstore/lib/types.h>
#include <solomon/services/memstore/lib/index/metrics.h>

#include <solomon/libs/cpp/actors/test_runtime/actor_runtime.h>
#include <solomon/libs/cpp/slog/log_data.h>
#include <solomon/libs/cpp/slog/slog.h>
#include <solomon/libs/cpp/slog/testlib/testlib.h>
#include <solomon/libs/cpp/ts_model/points.h>
#include <solomon/libs/cpp/ts_model/testlib/testlib.h>

#include <library/cpp/actors/core/actor.h>
#include <library/cpp/actors/core/actorsystem.h>
#include <library/cpp/testing/gtest/gtest.h>

class TIndexTestBase: public ::testing::Test {
protected:
    void SetUp() override {
        Test::SetUp();
        Registry = std::make_shared<NMonitoring::TMetricRegistry>();
        Metrics = std::make_shared<NSolomon::NMemStore::NIndex::TMetrics>(Registry);

        Runtime = NSolomon::TTestActorRuntime::CreateInited();
        Runtime->SetLogPriority(NSolomon::Index, NActors::NLog::PRI_DEBUG);
    }

    void TearDown() override {
        Runtime.Reset();
        Test::TearDown();
    }

    void ExecuteInContext(std::function<void(const NActors::TActorContext&)> f);

public:
    std::shared_ptr<NMonitoring::TMetricRegistry> Registry;
    THolder<NSolomon::TTestActorRuntime> Runtime;
    std::shared_ptr<NSolomon::NMemStore::NIndex::TMetrics> Metrics;
};
