#pragma once

#include <solomon/services/memstore/lib/types.h>

#include <solomon/libs/cpp/shard_key/shard_key.h>

#include <library/cpp/actors/core/actorid.h>

namespace NSolomon::NMemStore::NIndex {

/**
 * A single request to index new data.
 */
struct TAddPointRequest {
    /**
     * Meta in SLog format.
     */
    TString Meta;

    /**
     * Data in SLog format.
     */
    TString Data;

    /**
     * Where to send an `TIndexDone` response after the data has been written.
     */
    NActors::TActorId ReplyTo;

    ui64 Cookie;

    ui64 SizeBytes() const noexcept {
        return Meta.size() + Data.size();
    }
};

/**
 * Multiple requests to index data in a single shard.
 */
struct TShardAddPointRequests {
    /**
     * Shard identifier.
     */
    TNumId NumId{};

    /**
     * Shard composite key.
     */
    TShardKey ShardKey;

    /**
     * Requests for indexing.
     */
    TVector<TAddPointRequest> Requests;
};

} // namespace NSolomon::NMemStore::NIndex
