LIBRARY()

OWNER(g:solomon)

SRCS(
    add_point.cpp
    find.cpp
    index_limiter.cpp
    label_keys.cpp
    label_values.cpp
    metrics.cpp
    read.cpp
    shard.cpp
    shard_manager.cpp
    shard_manager_config.cpp
    snapshot.cpp
    subshard.cpp
    unique_labels.cpp
)

PEERDIR(
    solomon/services/memstore/lib/fts
    solomon/services/memstore/lib/labels
    solomon/services/memstore/lib/metric
    solomon/services/memstore/lib/slog
    solomon/services/memstore/lib/time_series

    solomon/libs/cpp/actors/events
    solomon/libs/cpp/actors/metrics
    solomon/libs/cpp/actors/poison
    solomon/libs/cpp/actors/util
    solomon/libs/cpp/backoff
    solomon/libs/cpp/conf_db/model
    solomon/libs/cpp/conf_db/table_loader
    solomon/libs/cpp/conf_db/ydb
    solomon/libs/cpp/conf_db/puller
    solomon/libs/cpp/error_or
    solomon/libs/cpp/intern
    solomon/libs/cpp/load_info_service
    solomon/libs/cpp/local_shard_provider
    solomon/libs/cpp/logging
    solomon/libs/cpp/proto_convert
    solomon/libs/cpp/selectors
    solomon/libs/cpp/selfmon
    solomon/libs/cpp/shard_key
    solomon/libs/cpp/clients/slicer
    solomon/libs/cpp/shard_metrics
    solomon/libs/cpp/slices
    solomon/libs/cpp/slog/snapshot_data
    solomon/libs/cpp/steady_timer
    solomon/libs/cpp/stockpile_codec
    solomon/libs/cpp/string_pool
    solomon/libs/cpp/ts_math
    solomon/libs/cpp/ts_model

    library/cpp/actors/core
    library/cpp/containers/absl_flat_hash
    library/cpp/monlib/metrics
)

IF(ALLOCATOR == "TCMALLOC_256K")
    SRCS(
        memory_tools_tcmalloc.cpp
    )
    PEERDIR(
        contrib/libs/tcmalloc/malloc_extension
    )
ELSE()
    SRCS(
        memory_tools_default.cpp
    )
ENDIF()

END()

RECURSE_FOR_TESTS(
    ut
)
