#include "labels.h"
#include "labels_pool.h"

#include <util/generic/algorithm.h>

namespace NSolomon::NMemStore::NLabels {

TLabels::TLabels(const NIntern::TStringId* labels)
    : Labels_(labels)
{
}

TLabels TLabels::CopyTo(TLabelsPool& pool) const {
    auto data = pool.Allocate();

    auto current = data;
    auto head = Labels_;
    while (*head != NIntern::InvalidStringId) {
        *current++ = *head++;
    }

    *current = NIntern::InvalidStringId;

    return {data};
}

void TLabels::Free(TLabelsPool& pool) {
    pool.Free(const_cast<TLabelsPool::TLabelPtr>(Labels_));
}

TLabelsOwned::TLabelsOwned(TTempArray<NIntern::TStringId> storage)
    : TLabels(storage.Data())
    , Storage_(std::move(storage))
{
}

} // namespace NSolomon::NMemStore::NIndex
