#include "labels_pool.h"

namespace NSolomon::NMemStore::NLabels {

TLabelsPool::TLabelPtr TLabelsPool::Allocate() {
    if (FreeLabels_.empty()) {
        return Pool_.AllocateArray<NIntern::TStringId>(LabelSize_);
    } else {
        auto ret = FreeLabels_.back();
        FreeLabels_.pop_back();
        return ret;
    }
}

void TLabelsPool::Free(TLabelPtr labelPtr) {
    FreeLabels_.push_back(labelPtr);
}

TLabelsPool::TLabelsPool(size_t initial)
    : Pool_{initial, TMemoryPool::TLinearGrow::Instance()}
{
}

size_t TLabelsPool::SizeBytes() const {
    return Pool_.MemoryAllocated() + Pool_.MemoryWaste() + FreeLabels_.capacity() * sizeof(TLabelPtr);
}

} // namespace NSolomon::NMemStore::NLabels
