#pragma once

#include <solomon/libs/cpp/intern/str_pool.h>
#include <util/generic/vector.h>
#include <util/memory/pool.h>

namespace NSolomon::NMemStore::NLabels {

class TLabelsPool {
public:
    using TLabelPtr = NIntern::TStringId*;

    explicit TLabelsPool(size_t initial);
    TLabelPtr Allocate();
    void Free(TLabelPtr);
    size_t SizeBytes() const;

private:
    TMemoryPool Pool_;
    TVector<TLabelPtr> FreeLabels_;
    static constexpr size_t LabelSize_ = 16 * 2 + 1;
};

} // namespace NSolomon::NMemStore::NLabels
