#include "match.h"

namespace NSolomon::NMemStore::NLabels {

bool Matches(TLabels labels, const NIntern::THashMapStringPool& pool, const TSelectors& selectors) {
    auto label = labels.Iter();
    auto selector = selectors.begin();

    while (label.HasValue() && selector != selectors.end()) {
        auto labelKey = pool.Find(label.Key());
        auto cmp = labelKey.compare(selector->Key());
        if (cmp < 0) {
            label.Advance();
        } else if (cmp > 0) {
            if (!selector->Match({})) {
                return false;
            }
            selector++;
        } else {
            if (!selector->Match(pool.Find(label.Value()))) {
                return false;
            }
            label.Advance();
            selector++;
        }
    }

    while (selector != selectors.end()) {
        if (!selector->Match({})) {
            return false;
        }
        selector++;
    }

    return true;
}

} // namespace NSolomon::NMemStore::NLabels
