#pragma once

#include "labels.h"

#include <solomon/libs/cpp/intern/str_pool_hash_map.h>
#include <solomon/libs/cpp/selectors/selectors.h>

namespace NSolomon::NMemStore::NLabels {

/**
 * Check if selectors match the given labels.
 *
 * This function assumes that selectors are sorted lexicographically by keys.
 *
 * @param labels        metric labels that need matching.
 * @param pool          pool used with `labels`.
 * @param selectors     selectors to match label against.
 */
bool Matches(TLabels labels, const NIntern::THashMapStringPool& pool, const TSelectors& selectors);

} // namespace NSolomon::NMemStore::NLabels
