#pragma once

#include <library/cpp/testing/gtest/gtest.h>

#include <solomon/services/memstore/lib/labels/labels.h>

#include <util/generic/vector.h>

inline auto LabelCases = ::testing::Values(
    NSolomon::NLabels::TLabels::OwnedStorage({}),
    NSolomon::NLabels::TLabels::OwnedStorage({{"sensor", "rps"}}),
    NSolomon::NLabels::TLabels::OwnedStorage({{"code", "200"}, {"sensor", "rps"}}),
    NSolomon::NLabels::TLabels::OwnedStorage({{"code", "200"}, {"host", "cluster"}, {"sensor", "rps"}}));

using TCtor = NSolomon::NMemStore::NLabels::TLabelsOwned(*)(
    NSolomon::NLabels::TLabelsView labels, NSolomon::NIntern::TStringPool& pool);

NSolomon::NMemStore::NLabels::TLabelsOwned Intern(
    NSolomon::NLabels::TLabelsView labels, NSolomon::NIntern::TStringPool& pool);

NSolomon::NMemStore::NLabels::TLabelsOwned Lookup(
    NSolomon::NLabels::TLabelsView labels, NSolomon::NIntern::TStringPool& pool);
