#include <library/cpp/testing/gtest/gtest.h>

#include <solomon/services/memstore/lib/labels/labels.h>

using namespace NSolomon::NMemStore::NLabels;

TEST(LabelsPool, TwoLabels) {
    TLabelsPool pool{1024};

    auto ptr1 = pool.Allocate();
    auto ptr2 = pool.Allocate();

    auto LabelSize = 33u;
    EXPECT_LE(ptr1 + LabelSize, ptr2);
}

TEST(LabelsPool, RemoveLabels) {
    TLabelsPool pool{1024};

    auto ptr1 = pool.Allocate();
    auto ptr2 = pool.Allocate();

    EXPECT_NE(ptr1, ptr2);

    pool.Free(ptr1);

    auto ptr3 = pool.Allocate();

    EXPECT_EQ(ptr1, ptr3);
}
