#pragma once

#include "error.h"

#include <solomon/libs/cpp/ts_model/points.h>

#include <library/cpp/monlib/encode/spack/varint.h>
#include <library/cpp/monlib/metrics/metric_type.h>

#include <util/stream/input.h>

namespace NSolomon::NMemStore::NSLog {

inline void Skip(IInputStream& in, size_t bytes) {
    if (Y_UNLIKELY(in.Skip(bytes) != bytes)) {
        ythrow TParsingError{} << "unexpected end of input";
    }
}

template <typename T>
inline T Read(IInputStream& in) {
    T out;
    if (Y_UNLIKELY(in.Load(&out, sizeof(out)) != sizeof(out))) {
        ythrow TParsingError{} << "unexpected end of input";
    }
    return out;
}

inline ui32 ReadVar(IInputStream& in) {
    ui32 out;
    switch (NMonitoring::TryReadVarUInt32(&in, &out)) {
        case NMonitoring::EReadResult::OK:
            return out;
        case NMonitoring::EReadResult::ERR_OVERFLOW:
            ythrow TParsingError{} << "var int is too large";
        case NMonitoring::EReadResult::ERR_UNEXPECTED_EOF:
            ythrow TParsingError{} << "unexpected end of input";
    }
}

} // namespace NSolomon::NMemStore::NSLog
