#include "file_name.h"

#include <util/string/cast.h>

namespace NSolomon::NMemStore {

static_assert(LOG_PREFIX.length() == TMP_LOG_PREFIX.length()
    && TMP_LOG_PREFIX.length() == SNAPSHOT_PREFIX.length()
    && SNAPSHOT_PREFIX.length() == TMP_SNAPSHOT_PREFIX.length());

constexpr ui16 MIN_FILENAME_SIZE = LOG_PREFIX.length() + NODE_ID_SIZE + 1;

TFilenameParts ParseMemstoreFilename(TStringBuf filename) {
    TFilenameParts fileNameParts;
    if (filename.size() < MIN_FILENAME_SIZE) {
        return fileNameParts;
    }

    const auto prefix = filename.NextTokAt(TMP_LOG_PREFIX.length());
    const auto nodeId = filename.NextTokAt(NODE_ID_SIZE);
    if (filename[0] != '.') {
        return fileNameParts;
    }

    if (prefix == LOG_PREFIX) {
        fileNameParts.Type = EFileType::Log;
    } else if (prefix == TMP_LOG_PREFIX) {
        fileNameParts.Type = EFileType::TempLog;
    } else if (prefix == SNAPSHOT_PREFIX) {
        fileNameParts.Type = EFileType::Snapshot;
    } else if (prefix == TMP_SNAPSHOT_PREFIX) {
        fileNameParts.Type = EFileType::TempSnapshot;
    } else {
        return fileNameParts;
    }

    ui32 nodeIdValue;
    if (TryFromString(nodeId, nodeIdValue)) {
        fileNameParts.NodeId = nodeIdValue;
    } else {
        fileNameParts.Type = EFileType::Unknown;
    }
    return fileNameParts;
}

} // namespace NSolomon::NMemStore
