#pragma once

#include <solomon/services/memstore/lib/types.h>

#include <library/cpp/actors/core/actorid.h>

namespace NSolomon::NMemStore {

struct TTabletLocation {
    TTabletId Id{0};
    TString Location;
};

struct TTabletActor {
    TTabletId Id{0};
    NActors::TActorId Actor;
};

struct TTabletFilesSize {
    ui64 TempFilesSize{0};
    ui64 LogFilesSize{0};
    ui64 SnapshotFilesSize{0};

    void Clear() {
        TempFilesSize = LogFilesSize = SnapshotFilesSize = 0;
    }
};

} // namespace NSolomon::NMemStore
