#pragma once

#include "model.h"

#include <solomon/services/memstore/lib/event_slots.h>
#include <solomon/services/memstore/lib/types.h>

#include <solomon/libs/cpp/actors/events/events.h>
#include <solomon/libs/cpp/actors/fwd.h>
#include <solomon/libs/cpp/clients/kikimr/rpc.h>

#include <library/cpp/actors/core/event_local.h>

namespace NSolomon::NMemStore {

class TStorageTabletEvents: private TEventSlot<EEventSpace::MemStore, ES_STORAGE_TABLET> {
    enum {
        Moved = SpaceBegin,
        Lost,
        StatsReq,
        StatsResp,
        FilesSizeReq,
        FilesSizeResp,
        End,
    };
    static_assert(End < SpaceEnd, "too many event types");

public:
    /**
     * Sent when tablet changed its location.
     */
    struct TMoved: public NActors::TEventLocal<TMoved, Moved> {
        TString Address;

        explicit TMoved(TString address) noexcept
            : Address{std::move(address)}
        {
        }
    };

    /**
     * Sent when tablet location become unknown.
     */
    struct TLost: public NActors::TEventLocal<TLost, Lost> {
    };

    /**
     * Request tablet stats.
     */
    struct TStatsReq: public NActors::TEventLocal<TStatsReq, StatsReq> {
    };

    /**
     * Tablet stats response.
     */
    struct TStatsResp: public NActors::TEventLocal<TStatsResp, StatsResp> {
        TTabletId TabletId;
        TString Address;
        double WritesRps{0.0};
        double ReadsRps{0.0};
        ui64 LogFilesSize{0};
        ui64 SnapshotFilesSize{0};
        ui64 TempFilesSize{0};
    };

    /**
     * Request to calculate total size of files, owned by one memstore instance, on this tablet.
     */
    struct TFilesSizeReq: public NActors::TEventLocal<TFilesSizeReq, FilesSizeReq> {
    };

    /**
     * Reports total size of files, owned by one memstore instance, on this tablet.
     */
    struct TFilesSizeResp: public NActors::TEventLocal<TFilesSizeResp, FilesSizeResp> {
        TTabletFilesSize TabletFilesSize;

        explicit TFilesSizeResp(const TTabletFilesSize& filesSize) noexcept
            : TabletFilesSize{filesSize}
        {
        }
    };
};

std::unique_ptr<NActors::IActor> StorageTablet(
        TNodeId nodeId,
        TTabletId tabletId,
        TString address,
        std::shared_ptr<NKikimr::IKikimrClusterRpc> rpc);

} // namespace NSolomon::NMemStore
