#pragma once

#include <util/datetime/base.h>

namespace NSolomon::NMemStore {

struct TPointsRange {
    TInstant MinTs = TInstant::Max();
    TInstant MaxTs = TInstant::Zero();

    void Update(const TPointsRange& oth) {
        MinTs = Min(MinTs, oth.MinTs);
        MaxTs = Max(MaxTs, oth.MaxTs);
    }

    void Update(const TInstant& time) {
        MinTs = Min(MinTs, time);
        MaxTs = Max(MaxTs, time);
    }

    bool Intersects(TInstant min, TInstant max) const {
        return min <= MaxTs && max >= MinTs;
    }
};

} // namespace NSolomon::NMemStore
