#include "time_series_frame.h"

#include <solomon/libs/cpp/ts_model/iterator_decode.h>
#include <solomon/libs/cpp/ts_model/point_traits.h>
#include <solomon/libs/cpp/ts_model/visit.h>

namespace NSolomon::NMemStore {

THolder<NTsModel::IGenericIterator> TTimeSeriesFrame::Iterator() const {
    return NTsModel::Visit(Type(), [this](auto traits) -> THolder <NTsModel::IGenericIterator> {
        using TPoint = typename decltype(traits)::TPoint;
        using TDecoder = NTsModel::TDecoder<TPoint>;
        return THolder(new NTsModel::TDecodeIterator <TPoint>{
            TDecoder{Columns_.ToColumnSet(traits.Type()), Data_}});
    });
}

} // namespace NSolomon::NMemStore
