#pragma once

#include "points_range.h"

#include <solomon/libs/cpp/ts_codec/bit_buffer.h>
#include <solomon/libs/cpp/ts_model/iterable.h>

namespace NSolomon::NMemStore {
/**
 * Data of a single frame.
 */
class TTimeSeriesFrame final : public NTsModel::IIterable {
public:
    TTimeSeriesFrame(
            NTs::TBitBuffer data,
            size_t numPoints,
            NTsModel::EPointType metricType,
            NTsModel::TPointColumns columns,
            TPointsRange range)
        : Data_{std::move(data)}
        , NumPoints_{numPoints}
        , MetricType_{metricType}
        , Columns_{columns}
        , Range_(range)
    {
    }

public:
    /**
     * Get reference to raw frame data.
     */
    NTs::TBitSpan Data() const noexcept {
        return Data_;
    }

    /**
     * Get number of points in this frame.
     */
    size_t NumPoints() const noexcept {
        return NumPoints_;
    }

    /**
     * Get ts columns for this data.
     */
    NTsModel::TPointColumns Columns() const noexcept override {
        return Columns_;
    }

    /**
     * Get type of this frame.
     */
    NTsModel::EPointType Type() const override {
        return MetricType_;
    }

    /**
     * Read data from this frame.
     */
    THolder <NTsModel::IGenericIterator> Iterator() const override;

    /**
     * Get timestamp of the first point in the frame.
     */
    TInstant WindowBegin() const override {
        return Range_.MinTs;
    }

    /**
     * Get timestamp of the last point in the frame.
     */
    TInstant WindowEnd() const override {
        return Range_.MaxTs;
    }

private:
    NTs::TBitBuffer Data_;
    size_t NumPoints_;
    NTsModel::EPointType MetricType_;
    NTsModel::TPointColumns Columns_;
    TPointsRange Range_;
};

} // namespace NSolomon::NMemStore
