#include "time_series_frames.h"

#include <solomon/libs/cpp/ts_model/iterator_crop.h>
#include <solomon/libs/cpp/ts_model/iterator_decode.h>
#include <solomon/libs/cpp/ts_model/iterator_merge.h>
#include <solomon/libs/cpp/ts_model/visit.h>

namespace NSolomon::NMemStore {

THolder<NTsModel::IGenericIterator> TTimeSeriesFrames::Iterator() const {
    return NTsModel::Visit(MetricType_, [this](auto traits) -> THolder <NTsModel::IGenericIterator> {
        using TPoint = typename decltype(traits)::TPoint;
        using TDecoder = NTsModel::TDecoder<TPoint>;
        using TDecodeIt = NTsModel::TDecodeIterator<TPoint>;
        using TMergeIt = NTsModel::TMergeIterator<TDecodeIt>;
        using TCropIt = NTsModel::TCropIterator<TMergeIt>;

        TVector<typename TMergeIt::TWindow> windows;
        windows.reserve(Frames_.size());
        for (auto& frame: Frames_) {
            windows.push_back(typename TMergeIt::TWindow{
                TDecodeIt{TDecoder{frame.Columns().ToColumnSet(Type()), frame.Data()}},
                frame.WindowBegin(),
                frame.WindowEnd()
            });
        }

        return THolder(new TCropIt{TMergeIt{windows.begin(), windows.end()}, WindowBegin_, WindowEnd_});
    });
}

} // namespace NSolomon::NMemStore
