#pragma once

namespace NSolomon::NMemStore {

/**
 * Statistics of memory usage of frame objects of one type: sealed or mutable
 */
struct TFramesMemoryStat {
    // how many frames of given type stored in time series object
    i64 FramesCount{0ull};
    // how many points are in the frames of given type in time series object
    i64 PointsCount{0ull};
    // actual useful space in bit buffers occupied by encoded points
    i64 DataSizeBytes{0ull};
    // memory allocated by buffers (always >= DataSizeBytes),
    // so BuffersSizeBytes - DataSizeBytes is the size of excessive allocated memory
    i64 BuffersSizeBytes{0ull};
    // total size of frames without buffers
    i64 FramesSizeBytes{0ull};
    // total size of TFrame objects
    i64 FrameHoldersSizeBytes{0ull};

    TFramesMemoryStat operator +(const TFramesMemoryStat& other) const {
        TFramesMemoryStat stat(*this);
        stat += other;
        return stat;
    }

    TFramesMemoryStat operator -(const TFramesMemoryStat& other) const {
        TFramesMemoryStat stat(*this);
        stat -= other;
        return stat;
    }

    TFramesMemoryStat& operator +=(const TFramesMemoryStat& other) {
        FramesCount += other.FramesCount;
        PointsCount += other.PointsCount;
        DataSizeBytes += other.DataSizeBytes;
        BuffersSizeBytes += other.BuffersSizeBytes;
        FramesSizeBytes += other.FramesSizeBytes;
        FrameHoldersSizeBytes += other.FrameHoldersSizeBytes;
        return *this;
    }

    TFramesMemoryStat& operator -=(const TFramesMemoryStat& other) {
        FramesCount -= other.FramesCount;
        PointsCount -= other.PointsCount;
        DataSizeBytes -= other.DataSizeBytes;
        BuffersSizeBytes -= other.BuffersSizeBytes;
        FramesSizeBytes -= other.FramesSizeBytes;
        FrameHoldersSizeBytes -= other.FrameHoldersSizeBytes;
        return *this;
    }
};

/**
 * Statistics of memory usage of time series object
 */
struct TTsMemoryStat {
    TFramesMemoryStat MutableFramesStat;
    TFramesMemoryStat SealedFramesStat;
    i64 DequeCapacityBytes{0ull};
    i64 BuffersCacheSizeBytes{0ull};

    TTsMemoryStat operator +(const TTsMemoryStat& other) const {
        TTsMemoryStat stat(*this);
        stat += other;
        return stat;
    }

    TTsMemoryStat operator -(const TTsMemoryStat& other) const {
        TTsMemoryStat stat(*this);
        stat -= other;
        return stat;
    }

    TTsMemoryStat& operator +=(const TTsMemoryStat& other) {
        MutableFramesStat += other.MutableFramesStat;
        SealedFramesStat += other.SealedFramesStat;
        DequeCapacityBytes += other.DequeCapacityBytes;
        BuffersCacheSizeBytes += other.BuffersCacheSizeBytes;
        return *this;
    }

    TTsMemoryStat& operator -=(const TTsMemoryStat& other) {
        MutableFramesStat -= other.MutableFramesStat;
        SealedFramesStat -= other.SealedFramesStat;
        DequeCapacityBytes -= other.DequeCapacityBytes;
        BuffersCacheSizeBytes -= other.BuffersCacheSizeBytes;
        return *this;
    }
};

} // namespace NSolomon::NMemStore
