#pragma once

#include <util/generic/ylimits.h>

#include <util/generic/string.h>
#include <util/system/types.h>
#include <util/system/yassert.h>

#include <contrib/libs/grpc/include/grpcpp/impl/codegen/status_code_enum.h>

#include <iostream>

namespace NSolomon::NMemStore {

/**
 * Unique node identifier.
 */
using TNodeId = ui32;

/**
 * Unique numeric identifier of a shard.
 */
using TNumId = ui32;

/**
 * Tablet identifier.
 */
using TTabletId = ui64;

/**
 * Transaction identifier.
 */
using TTxn = ui64;

/**
 * All data is split into 5-minute frames. Within a shard, all frames are indexed starting from 0th.
 */
using TFrameIdx = ui64;

/**
 * Global identifier of a single WAL record.
 */
struct TLogId {
    TTabletId TabletId;
    TTxn Txn;

    TLogId(TTabletId tabletId, TTxn txn)
        : TabletId(tabletId)
        , Txn(txn)
    {
    }

    friend bool operator==(const TLogId& lhs, const TLogId& rhs) {
        return lhs.Txn == rhs.Txn && lhs.TabletId == rhs.TabletId;
    }

    friend bool operator!=(const TLogId& lhs, const TLogId& rhs) {
        return !(rhs == lhs);
    }
};

inline void PrintTo(const TLogId& logId, std::ostream* os) {
    *os << "TLogId{" << logId.TabletId << ", " << logId.Txn << "}";
}

/**
 * Generic API error. Returned as part of response message from actors that process API requests.
 *
 * This class always contains an API error.
 */
class TApiError {
public:
    TApiError(grpc::StatusCode status, TString message)
        : Status_(status)
        , Message_(std::move(message))
    {
        Y_VERIFY_DEBUG(status != grpc::OK, "should be an error");
    }

public:
    grpc::StatusCode GetStatus() const {
        return Status_;
    }

    const TString& GetMessage() const {
        return Message_;
    }

private:
    grpc::StatusCode Status_;
    TString Message_;
};

} // namespace NSolomon::NMemStore
