#pragma once

#include "host_watcher.h"
#include "wal_events.h"
#include "write_queue.h"

#include <solomon/services/memstore/lib/index/index_limiter.h>

#include <solomon/libs/cpp/actors/events/common.h>
#include <solomon/libs/cpp/kv/actor_bridge/actor_bridge.h>

#include <util/generic/hash_set.h>

namespace NSolomon::NMemStore::NWal {

/**
 * Actors that interact with a single KV tablet.
 */
struct TTabletData {
    /**
     * Write queue for this tablet.
     */
    NActors::TActorId WriteQueue;

    /**
     * KV client that's currently used with this write queue.
     */
    NActors::TActorId Host;
};

/**
 * Dispatches new log records into corresponding write queues, also monitors hosts and assigns alive hosts to
 * write queues.
 *
 * When created, takes ownership over write queues, KV clients and host watchers.
 *
 * @param tablets       map from tablet ID to write queue that works with this tablet.
 * @param clients       all available KV clients.
 * @param watchers      all host watchers.
 */
std::unique_ptr<NActors::IActor> CreateDispatcher(
        THashMap<ui64, TTabletData> tablets,
        TVector<NActors::TActorId> clients,
        TVector<NActors::TActorId> watchers,
        NActors::TActorId shardManagerId,
        std::shared_ptr<NSolomon::NMemStore::NIndex::IIndexWriteLimiter> indexLimiter,
        NMonitoring::TMetricRegistry& registry);

} // namespace NSolomon::NMemStore::NWal
