#pragma once

#include "wal_events.h"

#include <solomon/services/memstore/lib/config/config.h>
#include <solomon/services/memstore/lib/index/index_limiter.h>

#include <solomon/libs/cpp/actors/events/common.h>

#include <library/cpp/actors/core/actorsystem.h>
#include <library/cpp/actors/core/actorid.h>
#include <library/cpp/monlib/metrics/metric_registry.h>

#include <util/generic/hash_set.h>

namespace NSolomon::NMemStore::NWal {

/**
 * Create and initialize WAL manager.
 *
 * This routine initializes KV client, scans all available tablets and detects latest transaction numbers,
 * the creates host watchers, write queues and a dispatcher over them.
 */
NActors::TActorId CreateWalManager(
        NActors::TActorSystem& actorSystem,
        ui32 executorPool,
        NActors::TActorId shardManager,
        const NConfig::TMemStoreConfig& config,
        const std::shared_ptr<NSolomon::NMemStore::NIndex::IIndexWriteLimiter>& indexLimiter,
        NMonitoring::TMetricRegistry& registry);

} // namespace NSolomon::NMemStore::NWal
