#pragma once

#include <library/cpp/testing/gtest/gtest.h>

#include <solomon/libs/cpp/actors/test_runtime/actor_runtime.h>
#include <solomon/libs/cpp/kv/actor_bridge/actor_bridge.h>
#include <solomon/libs/cpp/kv/testlib/testlib.h>

template <size_t NumTablets = 1>
class TWalFixture: public NSolomon::NKv::TTestFixtureTablet<NumTablets> {
public:
    void SetUp() override {
        NSolomon::NKv::TTestFixtureTablet<NumTablets>::SetUp();

        Runtime = NSolomon::TTestActorRuntime::CreateInited();
        Runtime->SetLogPriority(NSolomon::Wal, NActors::NLog::PRI_DEBUG);
    }

    void TearDown() override {
        Runtime.Reset();

        NSolomon::NKv::TTestFixtureTablet<NumTablets>::TearDown();
    }

public:

    THolder<NSolomon::TTestActorRuntime> Runtime;
    NMonitoring::TMetricRegistry Registry;
};
