#pragma once

#include <library/cpp/monlib/metrics/histogram_snapshot.h>
#include <solomon/libs/cpp/ts_model/points.h>
#include <solomon/libs/cpp/ts_codec/time_codec.h>

#include <vector>
#include <optional>

namespace NSolomon::NMemStore::NYasm {

using TBucket = NSolomon::NTs::NValue::THistogram::TBucket;
using TBuckets = std::vector<TBucket>;

class TUgramAligner {
public:
    TUgramAligner(TBuckets aligner);

    TBuckets Align(const TBuckets& buckets);

private:
    TBuckets Aligner_;
};

class TUgramAlignerBuilder {
public:
    void AddBuckets(const TBuckets& buckets);

    std::optional<TUgramAligner> ReleaseAligner();

    void Reset();

private:
    TBuckets Buckets_;
    bool DifferentBounds_{false};
};

class TUgramBuilder {
public:
    void AddBucket(NMonitoring::TBucketBound lower, NMonitoring::TBucketBound upper, NMonitoring::TBucketValue value);
    void AddBucket(NMonitoring::TBucketBound upper, NMonitoring::TBucketValue value);

    TBuckets ReleaseBuckets();

private:
    TBuckets Buckets_;
};

bool Compress(TBuckets& buckets, size_t limit = NMonitoring::HISTOGRAM_MAX_BUCKETS_COUNT);

} // NSolomon::NMemStore::NYasm
