#include "index_benchmark.h"

#include <solomon/libs/cpp/config/units.h>

namespace NSolomon::NMemStore::NBenchmark {

std::unique_ptr<NActors::IActor> TIndexBenchmark::BuildShard() const {
    return CreateShard(ShardManagerId, shardNumId, Config, {}, false, IndexLimiter_, {}, Metrics_);
}

TIndexBenchmark::TIndexBenchmark(const MemStoreBenchmarkConfig& config)
        : Config(FromProtoTime(config.memstore_config().index().chunk_length()),
                 FromProtoTime(config.memstore_config().index().index_capacity()),
                 config.memstore_config().index().subshard_count())
        , Registry_(std::make_shared<NMonitoring::TMetricRegistry>())
        , Metrics_{std::make_shared<TMetrics>(Registry_)} {
    auto& memstoreConfig = config.memstore_config();
    Runtime_ = TActorRuntime::Create(memstoreConfig.actor_system(), Registry_);
    Runtime_->Start();

    IndexLimiter_ = CreateIndexWriteLimiter(TIndexLimiterConfig::Default());
    ShardManagerId = Runtime_->Register(
            NIndex::CreateShardManager(Config, {}, IndexLimiter_, Registry_),
            NActors::TMailboxType::HTSwap,
            Runtime_->FindExecutorByName("index"));
    ShardId = Runtime_->ActorSystem().Register(
            BuildShard().release(),
            NActors::TMailboxType::HTSwap,
            Runtime_->FindExecutorByName("index"));
}

void TIndexBenchmark::SetSnapshotCollector(NActors::TActorId id) {
    Runtime_->ActorSystem()
        .Send(ShardManagerId, new NIndex::TShardManagerEvents::TEnableSnapshots(id));
}

ui64 TIndexBenchmark::GlobalLogId() const {
    return GlobalLogId_++;
}

NActors::TActorSystem& TIndexBenchmark::ActorSystem() {
    return Runtime_->ActorSystem();
}

NThreading::TFuture<void> TIndexBenchmark::SetQueueSizeCollector(ui32 /*maxQueueSize*/) {
    // TODO: implement it properly
    return NThreading::MakeFuture();
}

} //namespace NSolomon::NMemStore
