#pragma once

#include "index_benchmark.h"
#include "index_result_collector.h"

#include <solomon/services/memstore/lib/index/shard.h>
#include <solomon/services/memstore/lib/index/shard_manager.h>
#include <solomon/services/memstore/config/memstore_benchmark_config.pb.h>
#include <solomon/libs/cpp/actors/runtime/actor_runtime.h>

namespace NSolomon::NMemStore::NBenchmark {

using namespace NIndex;
using yandex::monitoring::memstore::MemStoreBenchmarkConfig;

class TIndexBenchmark {
public:
    std::unique_ptr<NActors::IActor> BuildShard() const;

    explicit TIndexBenchmark(const MemStoreBenchmarkConfig& config);

    void SetSnapshotCollector(NActors::TActorId id);

    ui64 GlobalLogId() const;

    NActors::TActorSystem& ActorSystem();

    TShardManagerConfig Config;

    NThreading::TFuture<void> SetQueueSizeCollector(ui32 MaxQueueSize);

    NActors::TActorId ShardId;
    NActors::TActorId ShardManagerId;
    static constexpr TNumId shardNumId = 10;

private:
    THolder<TActorRuntime> Runtime_;
    mutable ui64 GlobalLogId_ = 5;
    std::shared_ptr<IIndexWriteLimiter> IndexLimiter_;
    std::shared_ptr<NMonitoring::TMetricRegistry> Registry_;
    std::shared_ptr<TMetrics> Metrics_;
};

} // NSolomon::NMemStore::NBenchmark
