#pragma once

#include <solomon/libs/cpp/actors/fwd.h>

#include <library/cpp/threading/future/future.h>

namespace NSolomon::NMemStore::NBenchmark {

std::unique_ptr<NActors::IActor> CreateIndexDoneCollector(
        size_t expectedNumRequest,
        NThreading::TPromise<void> promise = NThreading::NewPromise());

std::unique_ptr<NActors::IActor> CreateSnapshotCollector(
        size_t expectedNumRequest,
        size_t snapshotSize = 0,
        NThreading::TPromise<void> promise = NThreading::NewPromise());

std::unique_ptr<NActors::IActor> CreateReadResponseCollector(
        size_t expectedNumMetrics,
        NThreading::TPromise<void> promise = NThreading::NewPromise());

} //namespace NSolomon::NMemStore::NBenchmark
