#include "index_benchmark.h"
#include "increasing_request.h"

#include <solomon/services/memstore/lib/api/service.h>
#include <solomon/services/memstore/lib/config/config.h>

#include <solomon/libs/cpp/actors/test_runtime/actor_runtime.h>
#include <solomon/libs/cpp/signals/signals.h>

#include <library/cpp/getopt/small/last_getopt_opts.h>
#include <library/cpp/getoptpb/getoptpb.h>

#include <util/system/getpid.h>

using namespace NSolomon;
using namespace NSolomon::NMemStore;
using namespace NSolomon::NMemStore::NApi;
using namespace NSolomon::NMemStore::NIndex;
using namespace NSolomon::NMemStore::NBenchmark;
using yandex::monitoring::memstore::MemStoreBenchmarkConfig;
using yandex::solomon::config::http::HttpServerConfig;

int Main(const MemStoreBenchmarkConfig& config) {
    TIndexBenchmark benchmark(config);

//    TRpcRequest rpcRequest(
//                    config.concurrency(),
//                    FromProtoTime(config.delay()),
//                    config.read_request_weight(),
//                    config.read_request_weight_increase(),
//                    config.write_request_weight(),
//                    config.write_request_weight_increase());

    TRpcRequest rpcRequest(config);

    Cout << "RPC = " << rpcRequest.CalcRpc(benchmark) << Endl;

    return 0;
}

int main(int argc, const char* argv[]) {
    NLastGetopt::TOpts opts;
    opts.AddLongOption("config", "path to configuration file")
            .Required()
            .RequiredArgument("<path>")
            .Completer(NLastGetopt::NComp::File("*.conf"));
    opts.AddVersionOption();
    opts.AddHelpOption();
    opts.AddCompletionOption("memstore");
    opts.SetFreeArgsNum(0);

    try {
        NLastGetopt::TOptsParseResult r(&opts, argc, argv);

        InitSignals();
        Cerr << "Starting MemStore (pid: " << GetPID() << ", SVN revision: " << GetArcadiaLastChange() << ')' << Endl;

        auto config = NConfig::LoadBenchmarkConfig(r.Get("config"));

        return Main(config);
    } catch (const NLastGetopt::TUsageException&) {
        opts.PrintUsage("memstore");
    } catch (const NConfig::TConfigParseException& e) {
        Cerr << "Cannot parse config: " << e.AsStrBuf() << Endl;
    } catch (const NConfig::TConfigValidationException& e) {
        Cerr << "Config is not valid: " << e.AsStrBuf() << Endl;
    } catch (...) {
        Cerr << "Unhandled exception: " << CurrentExceptionMessage() << ". Process will terminate" << Endl;
    }

    return 1;
}
