#include "simple_request.h"
#include <solomon/libs/cpp/slog/testlib/testlib.h>

namespace NSolomon::NMemStore::NBenchmark {

TSimpleRequest::TSimpleRequest(ui32 numOfRequests, TDuration delay, ui32 numOfHosts)
    : NumOfRequests (numOfRequests)
    , Delay(delay)
    , NumOfHosts(numOfHosts)
    , StartTime(TInstant::Now())
{
}

void TSimpleRequest::Run(TIndexBenchmark& benchmark) {
    auto getMetaData = [&](const std::string& suff) {
        auto log = NSolomon::NSlog::MakeSlog(TIndexBenchmark::shardNumId);
        for (ui32 i = 0; i < NumOfHosts; ++i)
            log.Gauge({{"host", "xx" + std::to_string(i) + "_" + suff}})
                    .Add("2000-01-01T00:02:10Z", 5)
                    .Add("2000-01-01T00:02:20Z", 10)
                    .Add("2000-01-01T00:02:30Z", 15)
                    .Done();
        return log.Done();
    };

//        auto numChunks = benchmark.Config.NumChunks * 2 + 1;
//        NThreading::TPromise<void> promiseIndex(NThreading::NewPromise());
//        NThreading::TPromise<void> promiseSnapshot(NThreading::NewPromise());

//        auto futureIndex = promiseIndex.GetFuture();
//        auto futureSnapshot = promiseSnapshot.GetFuture();

    auto snapshotSize = benchmark.Config.ChunkLength.MilliSeconds() / Delay.MilliSeconds() * NumOfRequests * NumOfHosts;
    auto& actorSystem = benchmark.ActorSystem();

    auto indexCollector = actorSystem.Register(CreateIndexDoneCollector(Max<ui32>()).release());
    auto snapshotCollector = actorSystem.Register(CreateSnapshotCollector(Max<ui32>(), snapshotSize).release());
    auto readCollector = actorSystem.Register(CreateReadResponseCollector(snapshotSize).release());

    //benchmark.SetQueueSizeCollector(20U);
    benchmark.SetSnapshotCollector(snapshotCollector);

    Cout << "Start at:" << actorSystem.Timestamp() << Endl;

    int idx = 0;

    while (true) {
        for (ui32 requestId = 0; requestId < NumOfRequests; ++requestId) {
            auto[meta, data] = getMetaData(std::to_string(requestId) + "_" + std::to_string(idx));
            TShardKey ShardKey{"project", "cluster", "service"};
            actorSystem.Send(benchmark.ShardId, new TShardEvents::TIndex{
                {10, benchmark.GlobalLogId()},
                {TIndexBenchmark::shardNumId, ShardKey, {
                    {std::move(meta), std::move(data), indexCollector, 0}
                }}
            });

            auto* req = new TShardEvents::TReadMany;
            req->Lookup = std::make_unique<TShardEvents::TReadMany::TLookup>();
            req->Lookup->Selectors = ParseSelectors("{host=xx*}");

            actorSystem.Send(new NActors::IEventHandle{benchmark.ShardId, readCollector, req});
        }

        Sleep(Delay);
        Cout << "tik-tok " << idx << Endl;
        if (idx++ > 1'000'000)
            break;
    }
    Cout << "Writing Done: " << idx << "*" << NumOfHosts << "*" << NumOfRequests << Endl;
//        futureSnapshot.Wait();
}

TSimpleRequest::~TSimpleRequest() {
    auto duration = TInstant::Now() - StartTime;
    Cout << "Simple Request Duration: " << duration.MilliSeconds() << Endl;
}

} //namespace NSolomon::NMemStore::NBenchmark
