#!/bin/sh -e

# Before using this script build following programs
#    cd arcadia
#    ya make -r kikimr/driver
#    ya make -r solomon/tools/kv
#
# then add symlinks in ~/bin:
#   cd ~/bin
#   ln -s arcadia/kikimr/driver/kikimr
#   ln -s arcadia/solomon/tools/kv/kv
#
# and add ~/bin to your PATH, e.g.
#   export PATH=${HOME}/bin:${PATH}
#

if [ $# -ne 2 ]; then
    echo "usage: $0 {sts1|sts2} {sas|vla|man|myt|iva}"
    exit 1
fi

cluster=$1
dc=$2
path=/Solomon/ShortTermStorage/KV

kikimr -s grpc://${cluster}-${dc}.mon.yandex.net:2135 db schema mkdir $(dirname ${path})
kv create --host ${cluster}-${dc}.mon.yandex.net --path ${path} --tablets 4096

