#!/bin/sh -e

if [ $# -eq 0 ]; then
    echo "Usage: $0 <version>"
    exit 1
fi

VERSION="$1"

STS_CONFIGS="
    SOLOMON_PROD_STS1_MEMSTORE_IVA
    SOLOMON_PROD_STS1_MEMSTORE_MAN
    SOLOMON_PROD_STS1_MEMSTORE_MYT
    SOLOMON_PROD_STS1_MEMSTORE_SAS
    SOLOMON_PROD_STS1_MEMSTORE_VLA
    SOLOMON_PROD_STS2_MEMSTORE_IVA
    SOLOMON_PROD_STS2_MEMSTORE_MAN
    SOLOMON_PROD_STS2_MEMSTORE_MYT
    SOLOMON_PROD_STS2_MEMSTORE_SAS
    SOLOMON_PROD_STS2_MEMSTORE_VLA
"

for config in ${STS_CONFIGS}; do
    release z2 ${config} yandex-solomon-memstore=${VERSION} yandex-solomon-memstore-conf=${VERSION}
done

