#!/bin/sh -e

# Before using this script build following program
#    cd arcadia
#    ya make -r solomon/tools/kv
#
# then add symlink in ~/bin:
#   cd ~/bin
#   ln -s arcadia/solomon/tools/kv/kv
#
# and add ~/bin to your PATH, e.g.
#   export PATH=${HOME}/bin:${PATH}
#

if [ $# -ne 2 ]; then
    echo "usage: $0 {sts1|sts2} {sas|vla|man|myt|iva}"
    exit 1
fi

cluster=$1
dc=$2

KV_RM="kv rm --host ${cluster}-${dc}.mon.yandex.net --path /Solomon/ShortTermStorage/KV"

for shardId in $(seq 1 4096); do
    ${KV_RM} --shard ${shardId} --remove-by-prefix c.m.l || true
    ${KV_RM} --shard ${shardId} --remove-by-prefix c.d.l || true
    printf "\033[1000D${shardId} done"
done

printf "\n"

