#!/bin/sh -e

if [ $# -ne 2 ]; then
    echo "usage: $0 {sts1|sts2} {sas|vla|man|myt|iva}"
    exit 1
fi

cluster=$1
dc=$2

ya make --checkout ../../../tools/kv/
KV=../../../tools/kv/kv

ydb_host=${cluster}-${dc}.mon.yandex.net
kv_path=/Solomon/ShortTermStorage/KV

backup_txns() {
    kv_read="${KV} read --host ${ydb_host} --path ${kv_path}"
    rm -fr shards/
    for shardId in $(seq 1 4096); do
        mkdir -p shards/${shardId}
        ${kv_read} --shard ${shardId} c.d.txn.last > shards/${shardId}/txn
        printf "\rshard ${shardId}"
    done
    printf "\n"
}

restore_txns() {
    kv_write="${KV} write --host ${ydb_host} --path ${kv_path}"
    for shardId in $(seq 1 4096); do
        ${kv_write} --shard ${shardId} -i shards/${shardId}/txn t.d.txn.last
        printf "\rshard ${shardId}"
    done
    printf "\n"
}

prun() {
    group="$1"
    shift

    curl -s http://c.yandex-team.ru/api/groups2hosts/${group} \
        | parallel-ssh -p 128 -t 300 -h /dev/stdin -o stdout "$@"
}

echo "stop dumper"
prun solomon_prod_${cluster}_ydb_${dc} sudo s stop dumper

echo "stop memstore"
prun solomon_prod_${cluster}_memstore_${dc} sudo s stop memstore

echo "backup txns"
backup_txns

echo "drop KVs"
${KV} drop --host ${ydb_host} --path ${kv_path}
sleep 10

echo "create KVs"
${KV} create --host ${ydb_host} --path ${kv_path}

echo "restore txns"
restore_txns

echo "start memstore"
prun solomon_prod_${cluster}_memstore_${dc} sudo s start memstore

echo "start dumper"
prun solomon_prod_${cluster}_ydb_${dc} sudo s start dumper

