#!/bin/sh -e

if [ $# -ne 2 ]; then
    echo "usage: $0 {sts1|sts2} {sas|vla|man|myt|iva}"
    exit 1
fi

cluster=$1
dc=$2

KV_LS="kv ls --host ${cluster}-${dc}.mon.yandex.net --path /Solomon/ShortTermStorage/KV"

echo "ShardId\tSize (MiB)"
for shardId in $(seq 1 4096); do
    size=$(${KV_LS} --shard ${shardId} | awk '{s += $2} END {print s / 1024 / 1024}')
    echo "${shardId}\t${size}"
done
