#include "metrics_dao.h"

#include <library/cpp/threading/future/future.h>

#include <util/generic/hash.h>
#include <util/generic/hash.h>

namespace NMetabase {
namespace {

class TInMemoryMetricsDao: public IMetricsDao {
public:
    TAsyncVoid CreateTable() override {
        return NThreading::MakeFuture();
    }

    TAsyncUi64 Count() const override {
        return NThreading::MakeFuture(Metrics_.size());
    }

    TAsyncMetrics ReadAll() const override {
        return NThreading::MakeFuture(AllMetrics());
    }

    TAsyncVoid Replace(const TVector<TMetricMeta>& metrics) override {
        for (const auto& m: metrics) {
            Metrics_[m.Labels] = m;
        }
        return NThreading::MakeFuture();
    }

    TAsyncVoid Delete(const TVector<TString>& labels) override {
        for (const auto& l: labels) {
            Metrics_.erase(l);
        }
        return NThreading::MakeFuture();
    }

private:
    TVector<TMetricMeta> AllMetrics() const {
        TVector<TMetricMeta> metrics;
        metrics.reserve(Metrics_.size());
        for (const auto& [_, m]: Metrics_) {
            metrics.push_back(m);
        }
        return metrics;
    }

private:
    THashMap<TString, TMetricMeta> Metrics_;
};

} // namespace

IMetricsDaoPtr InMemoryMetricsDao() {
    return new TInMemoryMetricsDao;
}

} // namespace NMetabase
